import QtQuick 2.0

Rectangle {
    property int currentValue: 0
    width: height * 3.55
    height: parent.height * 0.1
    color: "white"

    Button {
        id: btnMinus
        anchors.top: display.top
        anchors.bottom: display.bottom
        anchors.right: display.left
        height: parent.height
        width: height
        text:"-"
        onClicked: currentValue -= 1
    }

    Text {
        id: display
        anchors.centerIn: parent
        width: height * 1.55
        height: parent.height
        text: currentValue
        font.pixelSize: height *.75
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Button {
        id: btnPlus
        anchors.top: display.top
        anchors.bottom: display.bottom
        anchors.left: display.right
        height: parent.height
        width: height
        text:"+"
        onClicked: currentValue += 1
    }
}
